/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.red;

import com.megacrit.cardcrawl.actions.common.GainEnergyAction;
import com.megacrit.cardcrawl.actions.common.LoseHPAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Bloodletting
extends AbstractCard {
    private static final Logger logger = LogManager.getLogger(Bloodletting.class.getName());
    public static final String ID = "Bloodletting";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("Bloodletting");
    public static final String NAME = Bloodletting.cardStrings.NAME;
    public static final String DESCRIPTION = Bloodletting.cardStrings.DESCRIPTION;
    public static final String UPGRADE_DESCRIPTION = Bloodletting.cardStrings.UPGRADE_DESCRIPTION;
    private static final int COST = 0;
    private static final int HP_LOSS = 3;
    private static final int ENERGY_AMT = 1;
    private static final int POOL = 1;

    public Bloodletting() {
        super(ID, NAME, "red/skill/bloodLetting", "red/skill/bloodLetting", 0, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.RED, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.SELF, 1);
        this.magicNumber = this.baseMagicNumber = 1;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        AbstractDungeon.actionManager.addToBottom(new GainEnergyAction(this.magicNumber));
        logger.info(this.magicNumber);
        AbstractDungeon.actionManager.addToBottom(new LoseHPAction(p, p, 3));
    }

    @Override
    public AbstractCard makeCopy() {
        return new Bloodletting();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            this.upgradeName();
            this.upgradeMagicNumber(1);
            this.rawDescription = UPGRADE_DESCRIPTION;
            this.initializeDescription();
        }
    }
}

